/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWResolver;
import filenet.vw.api.VWSPResolver;
import filenet.vw.api.VWStepPaletteDefinition;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWXMLErrorHandler;
import filenet.vw.api.VWXML_10_parser;
import filenet.vw.api.VWXML_20_parser;
import filenet.vw.api.VWXML_30_parser;
import filenet.vw.api.VWXML_CUR_parser;
import filenet.vw.api.VWXPDL_20_parser;
import filenet.vw.base.XMLHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class VWXMLHandler {
    protected static final String API_XML_VERSION = "4.0";
    protected static final String DTDNAME_CUR = "wfdef4.dtd";
    protected static final String XSDNAME_CUR = "wfdef3.xsd";
    protected static final String XMLDefinition = "<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE WorkFlowDefinition SYSTEM \"wfdef4.dtd\">\n";
    protected static final String XMLWorkflowElementStart = "<WorkFlowDefinition ApiVersion=\"4.0\"\nOrigin=\"JavaAPI\"\n";
    protected static final String XMLPreamble = "<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE WorkFlowDefinition SYSTEM \"wfdef4.dtd\">\n<WorkFlowDefinition ApiVersion=\"4.0\"\nOrigin=\"JavaAPI\"\n";
    protected static final String SP_XSDNAME_CUR = "spdef4.dtd";
    protected static final String SP_XMLPreamble = "<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE StepPaletteDefinition SYSTEM \"spdef4.dtd\">\n<StepPaletteDefinition ApiVersion=\"4.0\"\nOrigin=\"JavaAPI\"\n";
    protected static final int EVENT_UNKNOWN = -1;
    protected static final int EVENT_START = 0;
    protected static final int EVENT_END = 1;
    protected static final String BASE_INDENT = "";
    protected static final String BUMP_INDENT = "\t";
    protected static final String WORKFLOW_INDENT = "";
    protected static final String RUNTIMEID_INDENT = "\t";
    protected static final String FIELD_INDENT = "\t";
    protected static final String MAP_INDENT = "\t";
    protected static final String STEP_INDENT = "\t\t";
    protected static final String ROUTE_INDENT = "\t\t\t";
    protected static final String PARAM_INDENT = "\t\t\t";
    protected static final String STEP_PALETTE_INDENT = "";
    private static final char HT = '\t';
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char SPACE = ' ';

    public static String _get_FILE_DATE() {
        return "$Date: 2011-01-06 01:27:35 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_452_Int/PUI_460_Int/PUI_510_Int/1 $";
    }

    protected static String getXMLIndent(int indentCount) {
        StringBuffer indentStr = new StringBuffer("");
        for (int i = 0; i < indentCount; ++i) {
            indentStr.append("\t");
        }
        return indentStr.toString();
    }

    protected static String incXMLIndent(String indent) {
        indent = indent + "\t";
        return indent;
    }

    protected static String decXMLIndent(String indent) {
        int length = indent.length();
        if (length > 0) {
            indent = indent.substring(0, length - 1);
        }
        return indent;
    }

    public static Document parseWorkflowDefinitionDocumentViaDOM(InputSource inSource) throws VWException, SAXException, IOException {
        return XMLHelper.parseDocumentViaDOM(inSource, new VWResolver(), new VWXMLErrorHandler(), false);
    }

    protected static VWMapDefinition parseXMLforPasteSteps(String theXML, VWWorkflowDefinition wfdef, boolean validate) throws IOException, SAXException, VWException, NumberFormatException {
        Document doc = VWXMLHandler.parseWorkflowDefinitionDocumentViaDOM(new InputSource(new StringReader(theXML)));
        Element wfele = doc.getDocumentElement();
        wfele.normalize();
        if (!wfele.getTagName().equals("WorkFlowDefinition")) {
            return null;
        }
        NodeList childNodes = wfele.getChildNodes();
        if (childNodes == null || childNodes.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node aNode = childNodes.item(i);
            if (!aNode.getNodeName().equals("Map")) continue;
            VWXML_CUR_parser.parseXMLMapDefinition(aNode, wfdef);
        }
        return null;
    }

    public static VWWorkflowDefinition parseXMLWorkFlow(Element wfele) throws IOException, SAXException, VWException, NumberFormatException {
        wfele.normalize();
        String verStr = wfele.getAttribute("ApiVersion");
        if (verStr == null || verStr.equals("")) {
            return null;
        }
        if (verStr.equals(API_XML_VERSION)) {
            return VWXML_CUR_parser.parseXMLWorkflow(wfele);
        }
        if (verStr.equals("3.0a")) {
            return VWXML_30_parser.parseXMLWorkflow(wfele);
        }
        if (verStr.equals("2.0")) {
            return VWXML_20_parser.parseXMLWorkflow(wfele);
        }
        if (verStr.equals("1.0")) {
            return VWXML_10_parser.parseXMLWorkflow(wfele);
        }
        throw new VWException("vw.VWXMLHandler.VWBadXMLFileVersion", "The XML file contains an ApiVersion attribute, {0}, Which cannot be parsed by this version of the PW API.", verStr);
    }

    public static VWWorkflowDefinition parseXPDLWorkFlow(Element wfele) throws IOException, SAXException, VWException, NumberFormatException {
        wfele.normalize();
        VWWorkflowDefinition wfdef = new VWWorkflowDefinition(true);
        VWXPDL_20_parser.XPDLInfo xpdlInfo = new VWXPDL_20_parser.XPDLInfo();
        VWXPDL_20_parser.parseXPDLWorkflowProcess(wfele, wfdef, xpdlInfo);
        return wfdef;
    }

    protected static VWWorkflowDefinition parseXMLWorkFlow(BufferedReader inputXML, boolean validate) throws IOException, SAXException, VWException, NumberFormatException {
        Document doc = VWXMLHandler.parseWorkflowDefinitionDocumentViaDOM(new InputSource(inputXML));
        Element wfele = doc.getDocumentElement();
        return VWXMLHandler.parseXMLWorkFlow(wfele);
    }

    protected static VWWorkflowCollectionDefinition parseXMLWorkFlowOrXPDL(InputStream inStream) throws IOException, SAXException, VWException, NumberFormatException {
        Document doc = VWXMLHandler.parseWorkflowDefinitionDocumentViaDOM(new InputSource(inStream));
        Element wfele = doc.getDocumentElement();
        wfele.normalize();
        String nodeName = wfele.getNodeName();
        String namespacePrefix = XMLHelper.getNamespaceFromNodeName(nodeName);
        if (nodeName != null && nodeName.equals(namespacePrefix + "Package")) {
            return VWXPDL_20_parser.parseXPDLDocument(wfele, namespacePrefix);
        }
        VWWorkflowDefinition wfdef = VWXMLHandler.parseXMLWorkFlow(wfele);
        if (wfdef == null) {
            return null;
        }
        VWWorkflowCollectionDefinition wfc = new VWWorkflowCollectionDefinition();
        wfc.addWorkflow(wfdef);
        wfc.setSource(1);
        return wfc;
    }

    public static VWStepPaletteDefinition parseXMLStepPalette(Element spele) throws IOException, SAXException, VWException, NumberFormatException {
        spele.normalize();
        String verStr = spele.getAttribute("ApiVersion");
        if (verStr == null || verStr.equals("")) {
            return null;
        }
        if (verStr.equals(API_XML_VERSION)) {
            return VWXML_CUR_parser.parseXMLStepPalette(spele);
        }
        throw new VWException("vw.VWXMLHandler.VWBadXMLFileVersion", "The XML file contains an ApiVersion attribute, {0}, Which cannot be parsed by this version of the PW API.", verStr);
    }

    protected static VWStepPaletteDefinition parseXMLStepPalette(BufferedReader inputXML, boolean validate) throws IOException, SAXException, VWException, NumberFormatException {
        Document doc = XMLHelper.parseDocumentViaDOM(new InputSource(inputXML), new VWSPResolver(), new VWXMLErrorHandler(), validate);
        Element spele = doc.getDocumentElement();
        return VWXMLHandler.parseXMLStepPalette(spele);
    }

    static String getXMLString(Node aNode) {
        NodeList childNodes = aNode.getChildNodes();
        if (childNodes == null) {
            return null;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 3) continue;
            return childNode.getNodeValue();
        }
        return null;
    }

    static String toXMLString(String buf) {
        int i;
        if (buf == null) {
            return "";
        }
        int len = buf.length();
        boolean specialChar = false;
        for (i = 0; i < len && !specialChar; ++i) {
            char aChar = buf.charAt(i);
            switch (aChar) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    specialChar = true;
                }
            }
            if (aChar >= ' ' || aChar == '\t' || aChar == '\r' || aChar == '\n') continue;
            specialChar = true;
        }
        if (!specialChar) {
            return buf;
        }
        StringBuffer sb = new StringBuffer();
        block14: for (i = 0; i < len; ++i) {
            char aChar = buf.charAt(i);
            if (aChar < ' ' && aChar != '\t' && aChar != '\r' && aChar != '\n') {
                sb.append("[!_" + Integer.valueOf(aChar) + "_!]");
                continue;
            }
            switch (aChar) {
                case '&': {
                    sb.append("&amp;");
                    continue block14;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block14;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block14;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block14;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block14;
                }
                case '\n': {
                    sb.append("&#10;");
                    continue block14;
                }
                case '\r': {
                    sb.append("&#13;");
                    continue block14;
                }
                case '\t': {
                    sb.append("&#09;");
                    continue block14;
                }
                default: {
                    sb.append(buf.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    static String booleanToString(boolean val) {
        if (val) {
            return "true";
        }
        return "false";
    }

    static boolean stringToBoolean(String val) throws VWException {
        if (val == null || val.equals("")) {
            return false;
        }
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        throw new VWException("vw.api.VWBooleanTypeBadString", "String form of the boolean type is invalid: {0}", val);
    }

    static void writeXMLNode(Object node, String indentA, StringBuffer theBuffer) {
        int numChilds;
        Node aNode = (Node)node;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        theBuffer.append(indentA + "<" + ele.getNodeName());
        NamedNodeMap nnm = ele.getAttributes();
        int attributeCount = nnm.getLength();
        for (int i = 0; i < attributeCount; ++i) {
            Node attributeNode = nnm.item(i);
            theBuffer.append(" " + attributeNode.getNodeName() + "=\"" + attributeNode.getNodeValue() + "\"");
        }
        NodeList childNodes = ele.getChildNodes();
        if (childNodes == null || (numChilds = childNodes.getLength()) == 0) {
            theBuffer.append("/>\n");
        } else {
            theBuffer.append(">\n");
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                if (childNode.getNodeType() != 1) continue;
                VWXMLHandler.writeXMLNode(childNode, VWXMLHandler.incXMLIndent(indentA), theBuffer);
            }
            theBuffer.append(indentA + "</" + ele.getNodeName() + ">\n");
        }
    }
}

